package com.tbyf.his.print.service.impl;


import com.tbyf.his.print.domain.PrintMetadata;
import com.tbyf.his.print.mapper.PrintMetadataMapper;
import com.tbyf.his.print.service.IPrintMetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据元信息Service业务层处理
 *
 * @author x
 * @date 2022-02-25
 */
@Service
public class PrintMetadataServiceImpl implements IPrintMetadataService {
    @Autowired
    private PrintMetadataMapper printMetadataMapper;

    /**
     * 查询数据元信息
     *
     * @param metadataId 数据元信息主键
     * @return 数据元信息
     */
    @Override
    public PrintMetadata selectPrintMetadataByMetadataId(Long metadataId) {
        return printMetadataMapper.selectPrintMetadataByMetadataId(metadataId);
    }

    /**
     * 查询数据元信息列表
     *
     * @param printMetadata 数据元信息
     * @return 数据元信息
     */
    @Override
    public List<PrintMetadata> selectPrintMetadataList(PrintMetadata printMetadata) {
        return printMetadataMapper.selectPrintMetadataList(printMetadata);
    }

    /**
     * 新增数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    @Override
    public int insertPrintMetadata(PrintMetadata printMetadata) {
        return printMetadataMapper.insertPrintMetadata(printMetadata);
    }

    /**
     * 修改数据元信息
     *
     * @param printMetadata 数据元信息
     * @return 结果
     */
    @Override
    public int updatePrintMetadata(PrintMetadata printMetadata) {
        return printMetadataMapper.updatePrintMetadata(printMetadata);
    }

    /**
     * 批量删除数据元信息
     *
     * @param metadataIds 需要删除的数据元信息主键
     * @return 结果
     */
    @Override
    public int deletePrintMetadataByMetadataIds(Long[] metadataIds) {
        return printMetadataMapper.deletePrintMetadataByMetadataIds(metadataIds);
    }

    /**
     * 删除数据元信息信息
     *
     * @param metadataId 数据元信息主键
     * @return 结果
     */
    @Override
    public int deletePrintMetadataByMetadataId(Long metadataId) {
        return printMetadataMapper.deletePrintMetadataByMetadataId(metadataId);
    }
}
