package com.tbyf.his.system.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import com.tbyf.his.common.core.domain.entity.SysMenu;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.ArrayList;
import java.util.List;

/**
 * 应用模块管理对象 sys_module
 *
 * @author zq
 * @date 2022-05-30
 */
public class SysModule extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 模块id
     */
    private Long moduleId;

    /**
     * 引用id 映射表sys_application中的字段
     */
    @Excel(name = "引用id 映射表sys_application中的字段")
    private Long applicationId;

    /**
     * 模块名称
     */
    @Excel(name = "模块名称")
    private String moduleName;

    /**
     * 一级模块id
     */
    @Excel(name = "一级模块id")
    private String parentId;

    /**
     * 序号
     */
    @Excel(name = "序号")
    private String serial;

    private List<SysModule> children = new ArrayList<SysModule>();

    public List<SysModule> getChildren() {
        return children;
    }

    public void setChildren(List<SysModule> children) {
        this.children = children;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getModuleId() {
        return moduleId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return parentId;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getSerial() {
        return serial;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("moduleId", getModuleId())
                .append("applicationId", getApplicationId())
                .append("moduleName", getModuleName())
                .append("parentId", getParentId())
                .append("remark", getRemark())
                .append("createBy", getCreateBy())
                .append("serial", getSerial())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
