package com.tbyf.his.system.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.annotation.Excels;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 插件对象 sys_plugin
 *
 * @author guoxw
 * @date 2022-07-10
 */
public class SysPlugin extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 插件ID
     */
    @Excel(name = "插件序号", cellType = Excel.ColumnType.NUMERIC, prompt = "插件编号")
    private Long pluginId;

    /**
     * 插件种类ID
     */
    @Excel(name = "插件种类ID", type = Excel.Type.IMPORT)
    private Long categoryId;

    /**
     * 插件名称
     */
    @Excel(name = "插件名称")
    private String pluginName;

    /**
     * 插件描述
     */
    @Excel(name = "插件描述")
    private String pluginDesc;

    /**
     * 插件类型（0.net 1java）
     */
    @Excel(name = "插件类型", readConverterExp = "0=.net,1=java")
    private String pluginType;

    /**
     * 插件地址
     */
    @Excel(name = "插件文件名称")
    private String pluginFileName;

    /**
     * 插件地址
     */
    @Excel(name = "插件地址")
    private String pluginPath;

    /**
     * 插件状态（0正常 1停用）
     */
    @Excel(name = "帐号状态", readConverterExp = "0=正常,1=停用")
    private String pluginStatus;

    /**
     * 插件版本
     */
    @Excel(name = "插件版本")
    private String pluginVersion;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    private String delFlag;

    /**
     * 插件种类对象
     */
    @Excels({
            @Excel(name = "插件种类名称", targetAttr = "categoryName", type = Excel.Type.EXPORT),
    })
    private SysCategory sysCategory;

    public void setPluginId(Long pluginId) {
        this.pluginId = pluginId;
    }

    public Long getPluginId() {
        return pluginId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return pluginName;
    }

    public void setPluginDesc(String pluginDesc) {
        this.pluginDesc = pluginDesc;
    }

    public String getPluginDesc() {
        return pluginDesc;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public String getPluginType() {
        return pluginType;
    }

    public void setPluginPath(String pluginPath) {
        this.pluginPath = pluginPath;
    }

    public String getPluginPath() {
        return pluginPath;
    }

    public void setPluginStatus(String pluginStatus) {
        this.pluginStatus = pluginStatus;
    }

    public String getPluginStatus() {
        return pluginStatus;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPluginVersion() {
        return pluginVersion;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public SysCategory getSysCategory() {
        return sysCategory;
    }

    public void setSysCategory(SysCategory sysCategory) {
        this.sysCategory = sysCategory;
    }

    public String getPluginFileName() {
        return pluginFileName;
    }

    public void setPluginFileName(String pluginFileName) {
        this.pluginFileName = pluginFileName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("pluginId", getPluginId())
                .append("categoryId", getCategoryId())
                .append("pluginName", getPluginName())
                .append("pluginDesc", getPluginDesc())
                .append("pluginType", getPluginType())
                .append("pluginFileName", getPluginFileName())
                .append("pluginPath", getPluginPath())
                .append("pluginStatus", getPluginStatus())
                .append("pluginVersion", getPluginVersion())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("sysCategory", getSysCategory())
                .append("remark", getRemark())
                .toString();
    }
}
