package com.tbyf.his.system.mapper;

import com.tbyf.his.system.domain.SysCategory;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 插件种类管理 数据层
 */
public interface SysCategoryMapper {

    /**
     * 查询插件种类数据
     *
     * @param category 插件种类信息
     * @return 插件种类信息集合
     */
    public List<SysCategory> selectCategoryList(SysCategory category);


    /**
     * 根据插件种类ID查询信息
     *
     * @param categoryId 插件种类ID
     * @return 插件种类信息
     */
    public SysCategory selectCategoryById(Long categoryId);

    /**
     * 根据ID查询所有子种类
     *
     * @param categoryId 插件种类ID
     * @return 插件种类列表
     */
    public List<SysCategory> selectChildrenCategoryById(Long categoryId);

    /**
     * 根据ID查询所有子种类（正常状态）
     *
     * @param categoryId 插件种类ID
     * @return 子种类数
     */
    public int selectNormalChildrenCategoryById(Long categoryId);

    /**
     * 是否存在子节点
     *
     * @param categoryId 插件种类ID
     * @return 结果
     */
    public int hasChildByCategoryId(Long categoryId);

    /**
     * 查询插件种类是否存在插件
     *
     * @param categoryId 插件种类ID
     * @return 结果
     */
    public int checkCategoryExistPlugin(Long categoryId);

    /**
     * 校验插件种类名称是否唯一
     *
     * @param categoryName 插件种类名称
     * @param parentId     父插件种类ID
     * @return 结果
     */
    public SysCategory checkCategoryNameUnique(@Param("categoryName") String categoryName, @Param("parentId") Long parentId);

    /**
     * 新增插件种类信息
     *
     * @param category 插件种类信息
     * @return 结果
     */
    public int insertCategory(SysCategory category);

    /**
     * 修改插件种类信息
     *
     * @param category 插件种类信息
     * @return 结果
     */
    public int updateCategory(SysCategory category);

    /**
     * 修改插件种类正常状态
     *
     * @param categoryIds 插件种类ID组
     */
    public void updateCategoryStatusNormal(Long[] categoryIds);

    /**
     * 修改子元素关系
     *
     * @param categories 子元素
     * @return 结果
     */
    public int updateCategoryChildren(@Param("categories") List<SysCategory> categories);

    /**
     * 删除插件种类信息
     *
     * @param CategoryId 插件种类ID
     * @return 结果
     */
    public int deleteCategoryById(Long CategoryId);

}
