package com.tbyf.his.system.service.impl;

import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysBjgTable;
import com.tbyf.his.system.mapper.SysBjgTableMapper;
import com.tbyf.his.system.service.ISysBjgTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 结构_说明Service业务层处理
 *
 * @author guopx
 * @date 2022-05-12
 */
@DataSource(value = DataSourceType.SLAVE)
@Service
public class SysBjgTableServiceImpl implements ISysBjgTableService {
    @Autowired
    private SysBjgTableMapper sysBjgTableMapper;

    /**
     * 查询结构_说明
     *
     * @param tabName 结构_说明主键
     * @return 结构_说明
     */
    @Override
    public SysBjgTable selectSysBjgTableByTabName(String tabName) {
        return sysBjgTableMapper.selectSysBjgTableByTabName(tabName);
    }

    /**
     * 查询结构_说明列表
     *
     * @param sysBjgTable 结构_说明
     * @return 结构_说明
     */
    @Override
    public List<SysBjgTable> selectSysBjgTableList(SysBjgTable sysBjgTable) {
        DataSourceUtil.switchDs("jdbc:oracle:thin:@192.168.0.39:1521:orcl", "oracle.jdbc.OracleDriver", "SA", "sa", "SA");
        return sysBjgTableMapper.selectSysBjgTableList(sysBjgTable);
    }

    /**
     * 模糊查询结构_说明
     *
     * @param sysBjgTable 结构_说明
     * @return 结构_说明
     */
    @Override
    public List<SysBjgTable> likeSelectSysBjgTable(SysBjgTable sysBjgTable) {
        DataSourceUtil.switchDs("jdbc:oracle:thin:@192.168.0.39:1521:orcl", "oracle.jdbc.OracleDriver", "SA", "sa", "SA");
        return sysBjgTableMapper.likeSelectSysBjgTable(sysBjgTable);
    }


    /**
     * 新增结构_说明
     *
     * @param sysBjgTable 结构_说明
     * @return 结果
     */
    @Override
    public int insertSysBjgTable(SysBjgTable sysBjgTable) {
        return sysBjgTableMapper.insertSysBjgTable(sysBjgTable);
    }

    /**
     * 修改结构_说明
     *
     * @param sysBjgTable 结构_说明
     * @return 结果
     */
    @Override
    public int updateSysBjgTable(SysBjgTable sysBjgTable) {
        return sysBjgTableMapper.updateSysBjgTable(sysBjgTable);
    }

    /**
     * 批量删除结构_说明
     *
     * @param tabNames 需要删除的结构_说明主键
     * @return 结果
     */
    @Override
    public int deleteSysBjgTableByTabNames(String[] tabNames) {
        return sysBjgTableMapper.deleteSysBjgTableByTabNames(tabNames);
    }

    /**
     * 删除结构_说明信息
     *
     * @param tabName 结构_说明主键
     * @return 结果
     */
    @Override
    public int deleteSysBjgTableByTabName(String tabName) {
        return sysBjgTableMapper.deleteSysBjgTableByTabName(tabName);
    }
}
