package com.tbyf.his.tool.vo;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;
import java.util.Map;

/**
 * @author: fr
 * @date: 2022年08月17日 16:34
 * <p>
 * 数据格式：
 * [{
 * "pid": 1,
 * "tableID": 1,
 * "tableList":[
 * {
 * "name": "张三",
 * "age": "16",
 * "phone": "13203215321",
 * "sex": "男",
 * "hobby": ["运动", "听歌"],
 * "keyData": [{"field": "name", "label": "姓名"}, {"field": "age", "label": "年龄"}, {
 * "field": "phone",
 * "label": "电话"
 * }, {"field": "sex", "label": "性别"}, {"field": "hobby", "label": "爱好"}]
 * }
 * ]
 * }]
 */
@Data
@Builder
public class TableDataVO {
    private Long pid;
    /**
     * todo 暂时不知道用途
     */
    private Long tableID;
    /**
     * 总行数
     */
    private Long total;
    /**
     * 标记一下主键字段，方便编辑保存
     */
    private String primaryKey;
    /**
     * 数据源id
     */
    private Long datasourceId;
    /**
     * 表名
     */
    private String tableName;
    /**
     * 供前端使用
     */
    private FormContent drawDataOne;
    private List<Map<String, Object>> tableList;

    @Tolerate
    public TableDataVO() {
    }
}
