export default class StringUtil {
    /**
     * 判断字符串是否为空
     * @param str
     * @returns {boolean|boolean}
     */
    static isEmpty(str) {
        return str === '' || str === null || str === undefined;
    }

    /**
     * 判断字符串是否相等,如果某个字符串为空,则返回false
     * @param str1
     * @param str2
     * @returns {boolean}
     */
    static equals(str1, str2) {
        if (this.isEmpty(str1) || this.isEmpty(str2)) {
            return false;
        }
        return str1.toString() === str2.toString();
    }

    /**
     * 多字符串合并展示
     * @param str
     * @returns {string}
     */
    static mergeStr(...str){
        return str.filter(item=>{
            return !this.isEmpty(item)
        }).join(" - ")
    }
}
