import request from '@/utils/request'

// 查询内部检查项目列表
export function listInExamItem(query) {
  return request({
    url: '/basis/inExamItem/list',
    method: 'get',
    params: query
  })
}

// 查询内部检查项目详细
export function getInExamItem(id) {
  return request({
    url: '/basis/inExamItem/' + id,
    method: 'get'
  })
}

// 新增内部检查项目
export function addInExamItem(data) {
  return request({
    url: '/basis/inExamItem',
    method: 'post',
    data: data
  })
}

// 修改内部检查项目
export function updateInExamItem(data) {
  return request({
    url: '/basis/inExamItem',
    method: 'put',
    data: data
  })
}

// 删除内部检查项目
export function delInExamItem(id) {
  return request({
    url: '/basis/inExamItem/' + id,
    method: 'delete'
  })
}

// 导出内部检查项目
export function exportInExamItem(query) {
  return request({
    url: '/basis/inExamItem/export',
    method: 'get',
    params: query
  })
}