import request from '@/utils/request'

const prefix = '/data/field'

/**
 * 字段查询
 * @param params
 * @returns {*}
 */
export function queryField(params) {
    return request({
        url: `${prefix}`,
        method: 'get',
        params
    })
}

/**
 * 新增字段
 * @param data
 * @returns {*}
 */
export function addField(data) {
    return request({
        url: `${prefix}`,
        method: 'post',
        data
    })
}

/**
 * 修改字段
 * @param data
 * @returns {*}
 */
export function updateField(data) {
    return request({
        url: `${prefix}/update`,
        method: 'post',
        data
    })
}


/**
 * 删除字段
 * @param fieldId
 * @returns {*}
 */
export function deleteField(fieldId) {
    return request({
        url: `${prefix}/delete`,
        method: 'get',
        params:{fieldId}
    })
}

/**
 * 根据基础模板重置字段
 * @param excelId
 * @returns {*}
 */
export function resetField(excelId,year){
    return request({
        url: `${prefix}/reset`,
        method: 'get',
        params:{excelId,year}
    })
}


/**
 * 元字段查询
 * @param params
 * @returns {*}
 */
export function queryMetaField(params) {
    return request({
        url: `${prefix}/meta`,
        method: 'get',
        params
    })
}

/**
 * 新增字段
 * @param data
 * @returns {*}
 */
export function addMetaField(data) {
    return request({
        url: `${prefix}/meta`,
        method: 'post',
        data
    })
}

/**
 * 修改字段
 * @param data
 * @returns {*}
 */
export function updateMetaField(data) {
    return request({
        url: `${prefix}/meta/update`,
        method: 'post',
        data
    })
}


/**
 * 删除字段
 * @param fieldId
 * @returns {*}
 */
export function deleteMetaField(fieldId) {
    return request({
        url: `${prefix}/meta/delete`,
        method: 'get',
        params:{fieldId}
    })
}

/**
 * 查询元字段字典
 * @returns {*}
 */
export function getMetaFieldDict() {
    return request({
        url: `${prefix}/meta/dict`,
        method: 'get',
    })
}

/**
 * 字段同步查询
 * @returns {*}
 */
export function querySyncField(templateId) {
    return request({
        url: `${prefix}/querySyncField`,
        method: 'get',
        params:{templateId}
    })
}

/**
 * 字段同步
 * @returns {*}
 */
export function syncField(data) {
    return request({
        url: `${prefix}/syncField`,
        method: 'post',
        data
    })
}

/**
 * 相同字段检测
 * @returns {*}
 */
export function sameFieldCheck(templateId) {
    return request({
        url: `${prefix}/sameFieldCheck`,
        method: 'get',
        params:{templateId}
    })
}


