export default class ObjectUtil {

    /**
     * 判断对象中的某个属性是否为空.可以逐层判断,例如 obj={a:{b:1}} isNull(obj,'a','b')
     * @param obj
     * @param keys
     * @returns {boolean}
     */
    static isNull(obj, ...keys) {
        if (!obj) {
            return true
        }
        if (!keys) {
            return true
        }
        let temp = obj
        for (let i = 0; i < keys.length; i++) {
            if (!temp[keys[i]]) {
                return true
            } else {
                temp = temp[keys[i]]
            }
        }
        return false
    }

    /**
     * 判断对象是否为空
     * @param obj
     * @returns {boolean|boolean}
     */
    static isEmpty(obj) {
        if (obj === '' || obj === null || obj === undefined) {
            return true;
        }
        try {
            return JSON.stringify(obj) === '{}';
        } catch (e) {
            return false;
        }
    }

    /**
     * 遍历对象,并使用consumer消费
     * @param obj {object}
     * @param consumer {function(string,any)}
     */
    static forEach(obj, consumer) {
        if (!this.isEmpty(obj)) {
            for (let key in obj) {
                consumer(key, obj[key])
            }
        }
    }


}
