import request from '@/utils/request'

export const prefix = '/mapi/info'

// 查询用户
export function listUser(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询用户
export function getUser(id) {
  return request({
    url: prefix + '/' + id,
    method: 'get'
  })
}

// 新增用户
export function addUser(data) {
  return request({
    url: prefix,
    method: 'post',
    data: data
  })
}

// 修改用户
export function updateUser(data) {
  return request({
    url: prefix,
    method: 'put',
    data: data
  })
}

// 删除用户
export function delUser(id) {
    return request({
      url: prefix + '/' + id,
      method: 'delete'
    })
  }

//导出用户
export function exportUser(query) {
  return request({
    url: prefix + '/export',
    method: 'get',
    params: query
  })
}