import request from '@/utils/request'

// 查询队列设置列表
export function listQueueSet(query) {
  return request({
    url: '/resource/queueSet/list',
    method: 'get',
    params: query
  })
}

// 查询队列设置详细
export function getQueueSet(id) {
  return request({
    url: '/resource/queueSet/' + id,
    method: 'get'
  })
}

// 根据队列ID查询队列设置详细
export function getQueueSetByQueueId(queueId) {
  return request({
    url: '/resource/queueSet/byQueueId/' + queueId,
    method: 'get'
  })
}

// 新增队列设置
export function addQueueSet(data) {
  return request({
    url: '/resource/queueSet',
    method: 'post',
    data: data
  })
}

// 修改队列设置
export function updateQueueSet(data) {
  return request({
    url: '/resource/queueSet',
    method: 'put',
    data: data
  })
}

// 删除队列设置
export function delQueueSet(id) {
  return request({
    url: '/resource/queueSet/' + id,
    method: 'delete'
  })
}

// 导出队列设置
export function exportQueueSet(query) {
  return request({
    url: '/resource/queueSet/export',
    method: 'get',
    params: query
  })
}
//状态
export function changeState(data) {
  return request({
    url: '/resource/queueSet/changeState',
    method: 'put',
    data: data
  })
}

// 生成时段
export function generateSchedule(query) {
  return request({
    url: '/resource/queueSet/generateSchedule',
    method: 'get',
    params: query
  })
}
