import request from "@/utils/request";

const prefix = '/data/excel'

/**
 * 上传excel
 * @param data
 * @returns {*}
 */
export function uploadExcel(data) {
    return request({
        url: `${prefix}/upload`,
        method: 'post',
        data,
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    })
}

/**
 * 下载模板
 * @param excelId
 * @returns {*}
 */
export function downloadTemplate(excelId) {
    return request({
        url: `${prefix}/download/template`,
        method: 'get',
        params:{excelId},
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        responseType: "blob",
    })
}

/**
 * 下载模板
 * @param excelId
 * @returns {*}
 */
export function getTemplateFileName(excelId) {
    return request({
        url: `${prefix}/download/template/filename`,
        method: 'get',
        params:{excelId}
    })
}

export async function blobValidate(data) {
    try {
        const text = await data.text();
        JSON.parse(text);
        return false;
    } catch (error) {
        return true;
    }
}

/**
 * 获取机构数据
 * @param orgName
 * @param year
 * @returns {*}
 */
export function queryArea(orgName,year) {
    return request({
        url: `${prefix}/queryArea`,
        method: 'get',
        params:{orgName,year}
    })
}
