import request from '@/utils/request'

// 查询机构列表
export function listDept(query) {
  return request({
    url: '/system/dept2/list',
    method: 'get',
    params: query
  })
}

// 查询机构详细
export function getDept(deptId) {
  return request({
    url: '/system/dept2/' + deptId,
    method: 'get'
  })
}

// 查询机构下拉树结构
export function treeselect() {
  return request({
    url: '/system/dept2/treeselect',
    method: 'get'
  })
}

// 根据角色ID查询机构树结构
export function roleDeptTreeselect(roleId) {
  return request({
    url: '/system/dept2/roleDeptTreeselect/' + roleId,
    method: 'get'
  })
}

// 新增机构
export function addDept(data) {
  return request({
    url: '/system/dept2',
    method: 'post',
    data: data
  })
}

// 修改机构
export function updateDept(data) {
  return request({
    url: '/system/dept2',
    method: 'put',
    data: data
  })
}

// 删除机构
export function delDept(deptId) {
  return request({
    url: '/system/dept2/' + deptId,
    method: 'delete'
  })
}
