export const getDefaultProps = () => ({
  uuid: '',
  type: 'braid-txt',
  name: '',
  isEdit: true,
  dragable: true, // 是否可拖拽
  resizable: true, // 尺寸是否可变
  width: 120,
  height: 40,
  left: 50,
  top: 0,
  value: '自定义文本',
  title: '自定义文本',
  defaultValue: '自定义文本',
  style: { zIndex: 1 }
})

export const getCodeTypeArray = () => (['128A', '128B', '128C', '128Auto', 'EAN8', 'EAN13', 'EAN128A',
  'EAN128B', 'EAN128C', 'Code39', '39Extended', '2_5interleaved', '2_5industrial', '2_5matrix', 'UPC_A',
  'UPC_E0', 'UPC_E1', 'UPCsupp2', 'UPCsupp5', 'Code93', '93Extended', 'MSI', 'PostNet', 'Codabar',
  'QRCode', 'PDF417'])

export const getItemTypeArray = () => ([
  { label: '普通项', value: 0 },
  { label: '页眉页脚', value: 1 },
  { label: '页号项', value: 2 },
  { label: '页数项', value: 3 },
  { label: '多页项', value: 4 }
])

export const getQRCodeErrorLevelArray = () => ([{ label: 'L  7%', value: 'L' },
  { label: 'M 15%', value: 'M' },
  { label: 'Q 25%', value: 'Q' },
  { label: 'H 30%', value: 'H' }])

export const option = [
  {
    type: 'braid-background',
    isEdit: 1,
    title: '背景图片(不打印)',
    value: '',
    defaultValue: '',
    name: ''
  },
  {
    type: 'braid-txt',
    isEdit: 1,
    title: '自定义文本',
    value: '',
    defaultValue: '',
    name: ''
  },
  {
    type: 'braid-line',
    isEdit: 0,
    title: '线条',
    name: '',
    style: {
      background: 'black',
      FontSize: 1
    }
  },
  {
    type: 'braid-line-flip',
    isEdit: 0,
    title: '线条(翻转)',
    name: '',
    style: {
      background: 'black',
      FontSize: 1
    }
  },
  {
    type: 'braid-rect',
    isEdit: 0,
    title: '矩形',
    name: '',
    style: {
      border: 'black'
    }
  },
  {
    type: 'bar-code',
    isEdit: 1,
    title: '条形码/二维码',
    height: 120,
    width: 120,
    name: '',
    lodopStyle: {
      QRCodeErrorLevel: 'L'
    }
  },
  {
    type: 'braid-html',
    isEdit: 1,
    title: '分页',
    value: '{第##页/共##页}',
    defaultValue: '<font><span tdata=\'pageNO\'>第##页</span>/<span tdata=\'pageCount\'>共##页</span></font>',
    name: ''
  }
]

export const baseOption = {
  'type': 'braid-txt',
  'isEdit': 1,
  'dragable': true,
  'resizable': true,
  'width': 120,
  'height': 40,
  'left': 50,
  'top': 0,
  'title': '自定义文本',
  'value': '',
  'defaultValue': '',
  'name': '',
  'style': {
    'zIndex': 1,
    'FontSize': 9,
    'FontColor': '#  000000',
    'Bold': false,
    'Italic': false,
    'Underline': false,
    'Alignment': 'left',
    'ItemType': 0
  },
  'lodopStyle': {}
}

export const sample = [
  {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 1,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '基本信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 14,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'consignmentShowId',
      'fieldType': 'TXT',
      'fieldName': '运单号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 15,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'consignmentType',
      'fieldType': 'TXT',
      'fieldName': '运单类型'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 16,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'settlementStatus',
      'fieldType': 'TXT',
      'fieldName': '结算状态'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 17,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'returnsState',
      'fieldType': 'TXT',
      'fieldName': '回单状态'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 18,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'consignmentFlag',
      'fieldType': 'TXT',
      'fieldName': '运单标识'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 19,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'consignmentSource',
      'fieldType': 'TXT',
      'fieldName': '运单来源'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 20,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendSite',
      'fieldType': 'TXT',
      'fieldName': '发送站点'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 21,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'arriveSite',
      'fieldType': 'TXT',
      'fieldName': '到达站点'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 24,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'changeState',
      'fieldType': 'TXT',
      'fieldName': '改单状态'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 36,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'paymentType',
      'fieldType': 'TXT',
      'fieldName': '收款类型'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 43,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'expectTakeTime',
      'fieldType': 'TXT',
      'fieldName': '要求提货时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 44,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualTakeTime',
      'fieldType': 'TXT',
      'fieldName': '实际提货时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 45,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'expectArriveTime',
      'fieldType': 'TXT',
      'fieldName': '要求送达时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 46,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualArriveTime',
      'fieldType': 'TXT',
      'fieldName': '实际送货时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 47,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'orderCompleteTime',
      'fieldType': 'TXT',
      'fieldName': '订单完成时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 48,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transportDirection',
      'fieldType': 'TXT',
      'fieldName': '运输指示'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 49,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transportRemark',
      'fieldType': 'TXT',
      'fieldName': '运输备注'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 50,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'emergencyDegree',
      'fieldType': 'TXT',
      'fieldName': '紧急程度'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 51,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickWay',
      'fieldType': 'TXT',
      'fieldName': '提货方式'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 52,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shippingMethod',
      'fieldType': 'TXT',
      'fieldName': '送货方式'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 53,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'returnsType',
      'fieldType': 'TXT',
      'fieldName': '回单类型'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 54,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'returnNumber',
      'fieldType': 'TXT',
      'fieldName': '回单数量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 55,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'responsiblePerson',
      'fieldType': 'TXT',
      'fieldName': '经办人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 56,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'clientConsignment',
      'fieldType': 'TXT',
      'fieldName': '客户运单号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 57,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'billStatus',
      'fieldType': 'TXT',
      'fieldName': '对账状态'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 251,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'createTime',
      'fieldType': 'TXT',
      'fieldName': '运单创建时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 252,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'consignmentBarCode',
      'fieldType': 'BARCODE',
      'fieldName': '运单条码'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 253,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'uploadReceiptQRCode',
      'fieldType': 'QRCODE',
      'fieldName': '上传回单二维码'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 254,
      'parentId': 1,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'selectQRCode',
      'fieldType': 'QRCODE',
      'fieldName': '查单二维码'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 2,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '客户信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 22,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperForwardingUnit',
      'fieldType': 'TXT',
      'fieldName': '发货单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 23,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperUserName',
      'fieldType': 'TXT',
      'fieldName': '发货人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 25,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperUserTel',
      'fieldType': 'TXT',
      'fieldName': '发货联系人电话'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 26,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperUserPhone ',
      'fieldType': 'TXT',
      'fieldName': '发货联系人手机'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 27,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperProvinceName ',
      'fieldType': 'TXT',
      'fieldName': '发货省份名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 28,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperCityName',
      'fieldType': 'TXT',
      'fieldName': '发货城市名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 29,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperCountyName',
      'fieldType': 'TXT',
      'fieldName': '发货县区名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 30,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperAddr',
      'fieldType': 'TXT',
      'fieldName': '发货地址'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 31,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'shipperRemark',
      'fieldType': 'TXT',
      'fieldName': '发货备注'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 32,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverForwardingUnit',
      'fieldType': 'TXT',
      'fieldName': '收货单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 33,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverUserName',
      'fieldType': 'TXT',
      'fieldName': '收货人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 34,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverUserPhone',
      'fieldType': 'TXT',
      'fieldName': '收货联系人手机号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 35,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverUserTel',
      'fieldType': 'TXT',
      'fieldName': '收货联系人电话'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 37,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverProvinceName',
      'fieldType': 'TXT',
      'fieldName': '收货省份名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 38,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverCityName',
      'fieldType': 'TXT',
      'fieldName': '收货城市名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 39,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverCountyName',
      'fieldType': 'TXT',
      'fieldName': '收货县区名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 40,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverAddr',
      'fieldType': 'TXT',
      'fieldName': '收货地址'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 42,
      'parentId': 2,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiverRemark',
      'fieldType': 'TXT',
      'fieldName': '收货备注'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 3,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '货物信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 138,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName1',
      'fieldType': 'TXT',
      'fieldName': '货物1名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 139,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases1',
      'fieldType': 'TXT',
      'fieldName': '货物1件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 140,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging1',
      'fieldType': 'TXT',
      'fieldName': '货物1包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 141,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight1',
      'fieldType': 'TXT',
      'fieldName': '货物1重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 142,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit1',
      'fieldType': 'TXT',
      'fieldName': '货物1重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 143,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume1',
      'fieldType': 'TXT',
      'fieldName': '货物1体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 144,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit1',
      'fieldType': 'TXT',
      'fieldName': '货物1体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 145,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice1',
      'fieldType': 'TXT',
      'fieldName': '货物1单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 146,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength1',
      'fieldType': 'TXT',
      'fieldName': '货物1长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 147,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width1',
      'fieldType': 'TXT',
      'fieldName': '货物1宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 148,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high1',
      'fieldType': 'TXT',
      'fieldName': '货物1高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 150,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName2',
      'fieldType': 'TXT',
      'fieldName': '货物2名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 151,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases2',
      'fieldType': 'TXT',
      'fieldName': '货物2件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 152,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging2',
      'fieldType': 'TXT',
      'fieldName': '货物2包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 153,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight2',
      'fieldType': 'TXT',
      'fieldName': '货物2重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 154,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit2',
      'fieldType': 'TXT',
      'fieldName': '货物2重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 155,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume2',
      'fieldType': 'TXT',
      'fieldName': '货物2体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 156,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit2',
      'fieldType': 'TXT',
      'fieldName': '货物2体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 157,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice2',
      'fieldType': 'TXT',
      'fieldName': '货物2单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 158,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength2',
      'fieldType': 'TXT',
      'fieldName': '货物2长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 159,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width2',
      'fieldType': 'TXT',
      'fieldName': '货物2宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 160,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high2',
      'fieldType': 'TXT',
      'fieldName': '货物2高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 161,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName3',
      'fieldType': 'TXT',
      'fieldName': '货物3名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 162,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases3',
      'fieldType': 'TXT',
      'fieldName': '货物3件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 163,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging3',
      'fieldType': 'TXT',
      'fieldName': '货物3包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 164,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight3',
      'fieldType': 'TXT',
      'fieldName': '货物3重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 165,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit3',
      'fieldType': 'TXT',
      'fieldName': '货物3重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 166,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume3',
      'fieldType': 'TXT',
      'fieldName': '货物3体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 167,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit3',
      'fieldType': 'TXT',
      'fieldName': '货物3体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 168,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice3',
      'fieldType': 'TXT',
      'fieldName': '货物3单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 169,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength3',
      'fieldType': 'TXT',
      'fieldName': '货物3长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 170,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width3',
      'fieldType': 'TXT',
      'fieldName': '货物3宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 171,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high3',
      'fieldType': 'TXT',
      'fieldName': '货物3高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 172,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName4',
      'fieldType': 'TXT',
      'fieldName': '货物4名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 173,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases4',
      'fieldType': 'TXT',
      'fieldName': '货物4件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 174,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging4',
      'fieldType': 'TXT',
      'fieldName': '货物4包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 175,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight4',
      'fieldType': 'TXT',
      'fieldName': '货物4重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 176,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit4',
      'fieldType': 'TXT',
      'fieldName': '货物4重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 177,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume4',
      'fieldType': 'TXT',
      'fieldName': '货物4体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 178,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit4',
      'fieldType': 'TXT',
      'fieldName': '货物4体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 179,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice4',
      'fieldType': 'TXT',
      'fieldName': '货物4单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 180,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength4',
      'fieldType': 'TXT',
      'fieldName': '货物4长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 181,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width4',
      'fieldType': 'TXT',
      'fieldName': '货物4宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 182,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high4',
      'fieldType': 'TXT',
      'fieldName': '货物4高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 183,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName5',
      'fieldType': 'TXT',
      'fieldName': '货物5名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 184,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases5',
      'fieldType': 'TXT',
      'fieldName': '货物5件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 185,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging5',
      'fieldType': 'TXT',
      'fieldName': '货物5包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 186,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight5',
      'fieldType': 'TXT',
      'fieldName': '货物5重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 187,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit5',
      'fieldType': 'TXT',
      'fieldName': '货物5重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 188,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume5',
      'fieldType': 'TXT',
      'fieldName': '货物5体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 189,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit5',
      'fieldType': 'TXT',
      'fieldName': '货物5体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 190,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice5',
      'fieldType': 'TXT',
      'fieldName': '货物5单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 191,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength5',
      'fieldType': 'TXT',
      'fieldName': '货物5长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 192,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width5',
      'fieldType': 'TXT',
      'fieldName': '货物5宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 193,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high5',
      'fieldType': 'TXT',
      'fieldName': '货物5高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 194,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName6',
      'fieldType': 'TXT',
      'fieldName': '货物6名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 195,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases6',
      'fieldType': 'TXT',
      'fieldName': '货物6件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 196,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging6',
      'fieldType': 'TXT',
      'fieldName': '货物6包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 197,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight6',
      'fieldType': 'TXT',
      'fieldName': '货物6重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 198,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit6',
      'fieldType': 'TXT',
      'fieldName': '货物6重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 199,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume6',
      'fieldType': 'TXT',
      'fieldName': '货物6体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 200,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit6',
      'fieldType': 'TXT',
      'fieldName': '货物6体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 201,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice6',
      'fieldType': 'TXT',
      'fieldName': '货物6单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 202,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength6',
      'fieldType': 'TXT',
      'fieldName': '货物6长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 203,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width6',
      'fieldType': 'TXT',
      'fieldName': '货物6宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 204,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high6',
      'fieldType': 'TXT',
      'fieldName': '货物6高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 205,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName7',
      'fieldType': 'TXT',
      'fieldName': '货物7名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 206,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases7',
      'fieldType': 'TXT',
      'fieldName': '货物7件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 207,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging7',
      'fieldType': 'TXT',
      'fieldName': '货物7包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 208,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight7',
      'fieldType': 'TXT',
      'fieldName': '货物7重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 209,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit7',
      'fieldType': 'TXT',
      'fieldName': '货物7重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 210,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume7',
      'fieldType': 'TXT',
      'fieldName': '货物7体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 211,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit7',
      'fieldType': 'TXT',
      'fieldName': '货物7体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 212,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice7',
      'fieldType': 'TXT',
      'fieldName': '货物7单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 213,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength7',
      'fieldType': 'TXT',
      'fieldName': '货物7长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 214,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width7',
      'fieldType': 'TXT',
      'fieldName': '货物7宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 215,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high7',
      'fieldType': 'TXT',
      'fieldName': '货物7高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 216,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName8',
      'fieldType': 'TXT',
      'fieldName': '货物8名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 217,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases8',
      'fieldType': 'TXT',
      'fieldName': '货物8件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 218,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging8',
      'fieldType': 'TXT',
      'fieldName': '货物8包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 219,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight8',
      'fieldType': 'TXT',
      'fieldName': '货物8重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 220,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit8',
      'fieldType': 'TXT',
      'fieldName': '货物8重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 221,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume8',
      'fieldType': 'TXT',
      'fieldName': '货物8体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 222,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit8',
      'fieldType': 'TXT',
      'fieldName': '货物8体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 223,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice8',
      'fieldType': 'TXT',
      'fieldName': '货物8单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 224,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength8',
      'fieldType': 'TXT',
      'fieldName': '货物8长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 225,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width8',
      'fieldType': 'TXT',
      'fieldName': '货物8宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 226,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high8',
      'fieldType': 'TXT',
      'fieldName': '货物8高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 227,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName9',
      'fieldType': 'TXT',
      'fieldName': '货物9名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 228,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases9',
      'fieldType': 'TXT',
      'fieldName': '货物9件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 229,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging9',
      'fieldType': 'TXT',
      'fieldName': '货物9包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 230,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight9',
      'fieldType': 'TXT',
      'fieldName': '货物9重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 231,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit9',
      'fieldType': 'TXT',
      'fieldName': '货物9重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 232,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume9',
      'fieldType': 'TXT',
      'fieldName': '货物9体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 233,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit9',
      'fieldType': 'TXT',
      'fieldName': '货物9体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 234,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice9',
      'fieldType': 'TXT',
      'fieldName': '货物9单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 235,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength9',
      'fieldType': 'TXT',
      'fieldName': '货物9长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 236,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width9',
      'fieldType': 'TXT',
      'fieldName': '货物9宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 237,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high9',
      'fieldType': 'TXT',
      'fieldName': '货物9高'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 238,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'materialName10',
      'fieldType': 'TXT',
      'fieldName': '货物10名称'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 239,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'numberCases10',
      'fieldType': 'TXT',
      'fieldName': '货物10件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 240,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'packaging10',
      'fieldType': 'TXT',
      'fieldName': '货物10包装'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 241,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualWeight10',
      'fieldType': 'TXT',
      'fieldName': '货物10重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 242,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'weightUnit10',
      'fieldType': 'TXT',
      'fieldName': '货物10重量单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 243,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'actualVolume10',
      'fieldType': 'TXT',
      'fieldName': '货物10体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 244,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'volumeUnit10',
      'fieldType': 'TXT',
      'fieldName': '货物10体积单位'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 245,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'unitPrice10',
      'fieldType': 'TXT',
      'fieldName': '货物10单价'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 246,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'proLength10',
      'fieldType': 'TXT',
      'fieldName': '货物10长'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 247,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'width10',
      'fieldType': 'TXT',
      'fieldName': '货物10宽'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 248,
      'parentId': 3,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'high10',
      'fieldType': 'TXT',
      'fieldName': '货物10高'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 4,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '费用信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 58,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeYF',
      'fieldType': 'TXT',
      'fieldName': '运费合计'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 59,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeTHF',
      'fieldType': 'TXT',
      'fieldName': '提货费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 60,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeSHF',
      'fieldType': 'TXT',
      'fieldName': '送货费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 61,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZXF',
      'fieldType': 'TXT',
      'fieldName': '装卸费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 62,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeBJF',
      'fieldType': 'TXT',
      'fieldName': '保价费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 63,
      'parentId': 4,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZYF',
      'fieldType': 'TXT',
      'fieldName': '额外费用'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 5,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '付款信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 64,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeXF',
      'fieldType': 'TXT',
      'fieldName': '现付'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 65,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeDF',
      'fieldType': 'TXT',
      'fieldName': '到付'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 66,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeHD',
      'fieldType': 'TXT',
      'fieldName': '货到打卡'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 67,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeYJ',
      'fieldType': 'TXT',
      'fieldName': '月结'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 68,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeHF',
      'fieldType': 'TXT',
      'fieldName': '回付'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 249,
      'parentId': 5,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'paymentType',
      'fieldType': 'TXT',
      'fieldName': '结算方式'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 6,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '干线信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 69,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'truckPlateNo',
      'fieldType': 'TXT',
      'fieldName': '车牌号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 70,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'driver',
      'fieldType': 'TXT',
      'fieldName': '主驾司机'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 71,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'driverPhone',
      'fieldType': 'TXT',
      'fieldName': '主驾司机电话'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 72,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'truckPlateNo',
      'fieldType': 'TXT',
      'fieldName': '发车时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 73,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'truckPlateNo',
      'fieldType': 'TXT',
      'fieldName': '卸车时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 74,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feexfysf',
      'fieldType': 'TXT',
      'fieldName': '现付运输费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 75,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feexfykf',
      'fieldType': 'TXT',
      'fieldName': '现付油卡费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 76,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feehfysf',
      'fieldType': 'TXT',
      'fieldName': '回付运输费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 77,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feedfysf',
      'fieldType': 'TXT',
      'fieldName': '到付运输费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 78,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feezcxxf',
      'fieldType': 'TXT',
      'fieldName': '整车信息费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 79,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feezcbxf',
      'fieldType': 'TXT',
      'fieldName': '整车保险费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 80,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feezcldf',
      'fieldType': 'TXT',
      'fieldName': '整车落地费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 81,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feefzzcf',
      'fieldType': 'TXT',
      'fieldName': '发站装车费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 82,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feefzqtf',
      'fieldType': 'TXT',
      'fieldName': '发站其他费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 83,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feedzxcf',
      'fieldType': 'TXT',
      'fieldName': '到站卸车费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 84,
      'parentId': 6,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feedzqtf',
      'fieldType': 'TXT',
      'fieldName': '到站其他费'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 7,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '提货信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 85,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpTime',
      'fieldType': 'TXT',
      'fieldName': '提货时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 86,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpCompleteTime',
      'fieldType': 'TXT',
      'fieldName': '提货完成时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 87,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'truckPlateNo',
      'fieldType': 'TXT',
      'fieldName': '车牌号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 88,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'driverPhone',
      'fieldType': 'TXT',
      'fieldName': '司机电话'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 89,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpNumber',
      'fieldType': 'TXT',
      'fieldName': '提货件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 90,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpWeight',
      'fieldType': 'TXT',
      'fieldName': '提货重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 91,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpVolume',
      'fieldType': 'TXT',
      'fieldName': '提货体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 92,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'pickUpRemarke',
      'fieldType': 'TXT',
      'fieldName': '提货备注'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 93,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'operatorName',
      'fieldType': 'TXT',
      'fieldName': '提货经办人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 115,
      'parentId': 7,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeTH',
      'fieldType': 'TXT',
      'fieldName': '提货费'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 8,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '送货信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 96,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendTime',
      'fieldType': 'TXT',
      'fieldName': '送货时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 97,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendCompleteTime',
      'fieldType': 'TXT',
      'fieldName': '送货完成时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 98,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'truckPlateNo',
      'fieldType': 'TXT',
      'fieldName': '车牌号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 99,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'driverPhone',
      'fieldType': 'TXT',
      'fieldName': '司机电话'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 100,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'gpsNo',
      'fieldType': 'TXT',
      'fieldName': 'GPS编号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 101,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendNumber',
      'fieldType': 'TXT',
      'fieldName': '送货件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 102,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendWeight',
      'fieldType': 'TXT',
      'fieldName': '送货重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 103,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendVolume',
      'fieldType': 'TXT',
      'fieldName': '送货体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 104,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendRemarke',
      'fieldType': 'TXT',
      'fieldName': '送货备注'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 105,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'operatorName',
      'fieldType': 'TXT',
      'fieldName': '送货经办人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 116,
      'parentId': 8,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeSH',
      'fieldType': 'TXT',
      'fieldName': '送货费'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 9,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '中转信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 106,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferTime',
      'fieldType': 'TXT',
      'fieldName': '中转时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 107,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferCompleteTime',
      'fieldType': 'TXT',
      'fieldName': '中转完成时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 108,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferCompany',
      'fieldType': 'TXT',
      'fieldName': '承运商'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 109,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferType',
      'fieldType': 'TXT',
      'fieldName': '中转方式'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 110,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferNumber',
      'fieldType': 'TXT',
      'fieldName': '中转件数'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 111,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferWeight',
      'fieldType': 'TXT',
      'fieldName': '中转重量'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 112,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferVolume',
      'fieldType': 'TXT',
      'fieldName': '中转体积'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 113,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'transferRemarke',
      'fieldType': 'TXT',
      'fieldName': '中转备注'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 114,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'operatorName',
      'fieldType': 'TXT',
      'fieldName': '中转经办人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 117,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZ',
      'fieldType': 'TXT',
      'fieldName': '中转费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 118,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZT',
      'fieldType': 'TXT',
      'fieldName': '中转提货费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 119,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZS',
      'fieldType': 'TXT',
      'fieldName': '中转送货费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 120,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZZ',
      'fieldType': 'TXT',
      'fieldName': '中转装卸费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 121,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZSL',
      'fieldType': 'TXT',
      'fieldName': '中转上楼费'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 122,
      'parentId': 9,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'feeZZQ',
      'fieldType': 'TXT',
      'fieldName': '中转其他费'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 10,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '签收信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 123,
      'parentId': 10,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'signTime',
      'fieldType': 'TXT',
      'fieldName': '签收时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 124,
      'parentId': 10,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'signer',
      'fieldType': 'TXT',
      'fieldName': '签收人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 125,
      'parentId': 10,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'signType',
      'fieldType': 'TXT',
      'fieldName': '签收类型'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 126,
      'parentId': 10,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'idcardNo',
      'fieldType': 'TXT',
      'fieldName': '身份证号'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 127,
      'parentId': 10,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'signSite',
      'fieldType': 'TXT',
      'fieldName': '签收网点'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 11,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '回单信息',
    'children': [{
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 128,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiptStatus',
      'fieldType': 'TXT',
      'fieldName': '回单状态'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 129,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiptUploadTime',
      'fieldType': 'TXT',
      'fieldName': '回单上传时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 130,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'recycleTime',
      'fieldType': 'TXT',
      'fieldName': '回收时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 131,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'recycleHandler',
      'fieldType': 'TXT',
      'fieldName': '回收操作人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 132,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendTime',
      'fieldType': 'TXT',
      'fieldName': '寄出时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 133,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'sendHandler',
      'fieldType': 'TXT',
      'fieldName': '寄出操作人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 134,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiveTime',
      'fieldType': 'TXT',
      'fieldName': '接收时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 135,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'receiveHandler',
      'fieldType': 'TXT',
      'fieldName': '接收操作人'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 136,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'issueTime',
      'fieldType': 'TXT',
      'fieldName': '发放时间'
    }, {
      'companyId': 110000,
      'siteId': 0,
      'deptId': null,
      'userId': null,
      'searchValue': null,
      'searchValues': null,
      'createBy': '',
      'createSite': '0',
      'createTime': '2021-02-24 15:42:02',
      'updateBy': '',
      'updateSite': null,
      'updateTime': null,
      'remark': null,
      'wholeMessageId': null,
      'params': {},
      'id': 137,
      'parentId': 11,
      'sort': 1,
      'showType': 'F',
      'fieldId': 'issueHandler',
      'fieldType': 'TXT',
      'fieldName': '发放操作人'
    }]
  }, {
    'companyId': 110000,
    'siteId': 0,
    'deptId': null,
    'userId': null,
    'searchValue': null,
    'searchValues': null,
    'createBy': '',
    'createSite': '0',
    'createTime': '2021-02-24 15:42:02',
    'updateBy': '',
    'updateSite': null,
    'updateTime': null,
    'remark': null,
    'wholeMessageId': null,
    'params': {},
    'id': 12,
    'parentId': 0,
    'sort': 1,
    'showType': 'C',
    'fieldId': null,
    'fieldType': '',
    'fieldName': '其他信息',
    'children': [
      {
        'companyId': 110000,
        'siteId': 0,
        'deptId': null,
        'userId': null,
        'searchValue': null,
        'searchValues': null,
        'createBy': '',
        'createSite': '0',
        'createTime': '2021-02-24 15:42:02',
        'updateBy': '',
        'updateSite': null,
        'updateTime': null,
        'remark': null,
        'wholeMessageId': null,
        'params': {},
        'id': 250,
        'parentId': 12,
        'sort': 1,
        'showType': 'F',
        'fieldId': 'QQ',
        'fieldType': 'TXT',
        'fieldName': 'QQ'
      },
      {
        'companyId': 110000,
        'siteId': 0,
        'deptId': null,
        'userId': null,
        'searchValue': null,
        'searchValues': null,
        'createBy': '',
        'createSite': '0',
        'createTime': '2021-02-24 15:42:02',
        'updateBy': '',
        'updateSite': null,
        'updateTime': null,
        'remark': null,
        'wholeMessageId': null,
        'params': {},
        'id': 251,
        'parentId': 12,
        'sort': 1,
        'showType': 'F',
        'fieldId': 'WeChat',
        'fieldType': 'TXT',
        'fieldName': 'WeChat'
      }
    ]
  }]
