import HttpUtil from "@/utils/document/HttpUtil.js";

/**
 * 获取应用列表
 * @returns {Promise<*>}
 */
export function getAppList() {
    return HttpUtil.postForJson("/app/list")
}

/**
 * 修改应用
 * @param data
 * @returns {Promise<*>}
 */
export function updateApp(data) {
    return HttpUtil.postForJson("/app/update", data)
}

/**
 * 添加应用
 * @param data
 * @returns {Promise<*>}
 */
export function addApp(data) {
    return HttpUtil.postForJson("/app/add", data)
}

/**
 * 删除授权
 * @param params
 * @returns {Promise<*>}
 */
export function removeApp(params) {
  return HttpUtil.getForJson("/app/remove", {
    params
  })
}

/**
 * 获取数据集树
 * @param params
 * @returns {Promise<{}|*>}
 */
export function getTree() {
  return HttpUtil.getForJson("/app/tree", {
  })
}

/**
 * 删除绑定数据集
 * @param data
 * @returns {Promise<{msg: string, code: number, data: *}|{msg, code: number, data: *}|*>}
 */
export function deleteDateset(data) {
  return HttpUtil.postForJson("/app/dataSet/delete", data)
}

/**
 * 修改绑定数据集
 * @param data
 * @returns {Promise<{msg: string, code: number, data: null}>}
 */
export function updateDateset(data) {
  return HttpUtil.postForJson("/app/dataSet/update", data)
}

/**
 * 添加绑定数据集
 * @param data
 * @returns {Promise<{msg: string, code: number, data: null}>}
 */
export function addDateset(data) {
  return HttpUtil.postForJson("/app/dataSet/add", data)
}
