import request from '@/utils/request'

// 查询院区信息列表
export function listYard(query) {
  return request({
    url: '/basis/yard/list',
    method: 'get',
    params: query
  })
}

// 查询院区信息详细
export function getYard(id) {
  return request({
    url: '/basis/yard/' + id,
    method: 'get'
  })
}

// 新增院区信息
export function addYard(data) {
  return request({
    url: '/basis/yard',
    method: 'post',
    data: data
  })
}

// 修改院区信息
export function updateYard(data) {
  return request({
    url: '/basis/yard',
    method: 'put',
    data: data
  })
}

// 删除院区信息
export function delYard(id) {
  return request({
    url: '/basis/yard/' + id,
    method: 'delete'
  })
}

// 导出院区信息
export function exportYard(query) {
  return request({
    url: '/basis/yard/export',
    method: 'get',
    params: query
  })
}