const KB = 1024
const MB = 1024 * 1024
const GB = 1024 * 1024 * 1024

export default class FileUtil {

    /**
     * 格式化文件大小
     * @param size  文件字节长度
     * @returns {string}
     */
    static fileSizeFormat(size) {
        let tempSize = parseInt(size)
        if (tempSize < KB) {
            return size + 'Byte'
        } else if (tempSize < MB) {
            return (tempSize / KB).toFixed(2) + "KB"
        } else if (tempSize < GB) {
            return (tempSize / MB).toFixed(2) + "MB"
        } else {
            return (tempSize / GB).toFixed(2) + "GB"
        }
    }

}