import request from '@/utils/request'

// 查询楼栋信息列表
export function listLocationInfo(query) {
  return request({
    url: '/basis/locationInfo/list',
    method: 'get',
    params: query
  })
}

export function listLocation(query) {
  return request({
    url: '/basis/locationInfo/info/list',
    method: 'get',
    params: query
  })
}

// 查询楼栋信息详细
export function getLocationInfo(id) {
  return request({
    url: '/basis/locationInfo/' + id,
    method: 'get'
  })
}

// 新增楼栋信息
export function addLocationInfo(data) {
  return request({
    url: '/basis/locationInfo',
    method: 'post',
    data: data
  })
}

// 修改楼栋信息
export function updateLocationInfo(data) {
  return request({
    url: '/basis/locationInfo',
    method: 'put',
    data: data
  })
}

// 新增位置信息
export function addLocation(data) {
  return request({
    url: '/basis/locationInfo/info/add',
    method: 'post',
    data: data
  })
}

// 修改位置信息
export function updateLocation(data) {
  return request({
    url: '/basis/locationInfo/info/update',
    method: 'post',
    data: data
  })
}

// 删除楼栋信息
export function delLocationInfo(id) {
  return request({
    url: '/basis/locationInfo/' + id,
    method: 'delete'
  })
}

// 删除位置信息
export function delLocation(id) {
  return request({
    url: '/basis/locationInfo/info/remove/' + id,
    method: 'post'
  })
}

// 导出楼栋信息
export function exportLocationInfo(query) {
  return request({
    url: '/basis/locationInfo/export',
    method: 'get',
    params: query
  })
}

// 位置字典
export function locationDict() {
  return request({
    url: '/basis/locationInfo/info/dict',
    method: 'get'
  })
}
