import request from '@/utils/request'

export const prefix = '/mapi/userView'

// 查询用户视图关联关系
export function listUserView(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询用户视图关联关系
export function getUserView(id) {
  return request({
    url: prefix + '/' + id,
    method: 'get'
  })
}

// 新增用户视图关联关系
export function addUserView(data) {
  return request({
    url: prefix,
    method: 'post',
    params: data
  })
}

// 修改用户视图关联关系
export function updateUserView(data) {
  return request({
    url: prefix,
    method: 'put',
    data: data
  })
}

// 删除用户视图关联关系
export function delUserView(id) {
    return request({
      url: prefix + '/' + id,
      method: 'delete'
    })
  }

//导出用户视图关联关系
export function exportUserView(query) {
  return request({
    url: prefix + '/export',
    method: 'get',
    params: query
  })
}
// 根据用户id查询数据
export function getUserMenu(userId) {
  return request({
    url: prefix + '/uid?userId=' + userId,
    method: 'get'
  })
}