import request from '@/utils/request'

// 查询就诊类型列表
export function listVisitType(query) {
  return request({
    url: '/system/visitType/list',
    method: 'get',
    params: query
  })
}

// 查询就诊类型详细
export function getVisitType(id) {
  return request({
    url: '/system/visitType/' + id,
    method: 'get'
  })
}

// 新增就诊类型
export function addVisitType(data) {
  return request({
    url: '/system/visitType',
    method: 'post',
    data: data
  })
}

// 修改就诊类型
export function updateVisitType(data) {
  return request({
    url: '/system/visitType',
    method: 'put',
    data: data
  })
}

// 删除就诊类型
export function delVisitType(id) {
  return request({
    url: '/system/visitType/' + id,
    method: 'delete'
  })
}

// 导出就诊类型
export function exportVisitType(query) {
  return request({
    url: '/system/visitType/export',
    method: 'get',
    params: query
  })
}