import request from '@/utils/request'

const prefix = '/dataImport'

/**
 * 模板查询
 * @param params
 * @returns {*}
 */
export function queryTemplate(params) {
    return request({
        url: `${prefix}/template`,
        method: 'get',
        params
    })
}

/**
 * 新增模板
 * @param data
 * @returns {*}
 */
export function addTemplate(data) {
    return request({
        url: `${prefix}/template`,
        method: 'post',
        data
    })
}

/**
 * 修改模板
 * @param data
 * @returns {*}
 */
export function updateTemplate(data) {
    return request({
        url: `${prefix}/template`,
        method: 'put',
        data
    })
}

/**
 * 删除模板
 * @param templateId
 * @returns {*}
 */
export function deleteTemplate(templateId) {
    return request({
        url: `${prefix}/template`,
        method: 'delete',
        params:{templateId}
    })
}


/**
 * 字典查询
 * @param type
 * @returns {*}
 */
export function queryDict(type) {
    return request({
        url: `${prefix}/dict`,
        method: 'get',
        params:{type}
    })
}

/**
 * 新增字典
 * @param data
 * @returns {*}
 */
export function addDict(data) {
    return request({
        url: `${prefix}/dict`,
        method: 'post',
        data
    })
}

/**
 * 修改字典
 * @param data
 * @returns {*}
 */
export function updateDict(data) {
    return request({
        url: `${prefix}/dict`,
        method: 'put',
        data
    })
}

/**
 * 删除字典
 * @param dictId
 * @returns {*}
 */
export function deleteDict(dictId) {
    return request({
        url: `${prefix}/dict`,
        method: 'delete',
        params:{dictId}
    })
}

/**
 * 查询数据源字典
 * @returns {AxiosPromise<any>}
 */
export function queryDatasource() {
    return request({
        url: `${prefix}/datasource`,
        method: 'get'
    })
}

/**
 * 查询表信息
 * @param dataSourceId
 * @returns {AxiosPromise<any>}
 */
export function queryTable(dataSourceId) {
    return request({
        url: `${prefix}/datasource/table`,
        method: 'get',
        params:{dataSourceId}
    })
}

/**
 * 查询数据库字段字典
 * @param dataSourceId
 * @param tableName
 * @returns {AxiosPromise}
 */
export function queryDbField(dataSourceId,tableName) {
    return request({
        url: `${prefix}/datasource/field`,
        method: 'get',
        params:{dataSourceId,tableName}
    })
}


/**
 * 字段查询
 * @param params
 * @returns {*}
 */
export function queryField(params) {
    return request({
        url: `${prefix}/field`,
        method: 'get',
        params
    })
}

/**
 * 新增字段
 * @param data
 * @returns {*}
 */
export function addField(data) {
    return request({
        url: `${prefix}/field`,
        method: 'post',
        data
    })
}

/**
 * 修改字段
 * @param data
 * @returns {*}
 */
export function updateField(data) {
    return request({
        url: `${prefix}/field`,
        method: 'put',
        data
    })
}

/**
 * 删除字段
 * @param fieldId
 * @returns {*}
 */
export function deleteField(fieldId) {
    return request({
        url: `${prefix}/field`,
        method: 'delete',
        params:{fieldId}
    })
}


/**
 * 规则查询
 * @param params
 * @returns {*}
 */
export function queryRule(params) {
    return request({
        url: `${prefix}/rule`,
        method: 'get',
        params
    })
}

/**
 * 规则字典
 * @returns {*}
 */
export function queryRuleDict() {
    return request({
        url: `${prefix}/rule/dict`,
        method: 'get'
    })
}

/**
 * 新增规则
 * @param data
 * @returns {*}
 */
export function addRule(data) {
    return request({
        url: `${prefix}/rule`,
        method: 'post',
        data
    })
}

/**
 * 修改规则
 * @param data
 * @returns {*}
 */
export function updateRule(data) {
    return request({
        url: `${prefix}/rule`,
        method: 'put',
        data
    })
}

/**
 * 删除规则
 * @param ruleId
 * @returns {*}
 */
export function deleteRule(ruleId) {
    return request({
        url: `${prefix}/rule`,
        method: 'delete',
        params:{ruleId}
    })
}

/**
 * 规则测试
 * @param data
 * @returns {*}
 */
export function ruleTest(data) {
    return request({
        url: `${prefix}/rule/test`,
        method: 'post',
        data
    })
}

/**
 * 快速绑定
 * @param templateId
 * @param ruleId
 * @returns {AxiosPromise}
 */
export function quickBind(templateId,ruleId) {
    return request({
        url: `${prefix}/bind/quick`,
        method: 'get',
        params:{templateId,ruleId}
    })
}

/**
 * 查询绑定的规则
 * @param fieldId
 * @returns {AxiosPromise}
 */
export function queryBindRule(fieldId) {
    return request({
        url: `${prefix}/bind`,
        method: 'get',
        params:{fieldId}
    })
}

/**
 * 配置字段规则绑定
 * @param data
 * @returns {AxiosPromise}
 */
export function bindRule(data) {
    return request({
        url: `${prefix}/bind`,
        method: 'post',
        data
    })
}

/**
 * 上传excel
 * @param data
 * @returns {*}
 */
export function uploadExcel(data) {
    return request({
        url: `${prefix}/upload`,
        method: 'post',
        data,
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    })
}

/**
 * 根据基础模板重置字段
 * @param excelId
 * @returns {*}
 */
export function resetField(excelId){
    return request({
        url: `${prefix}/field/reset`,
        method: 'get',
        params:{excelId}
    })
}

