import request from '@/utils/request'

// 查询检查队列列表
export function listQueue(query) {
  return request({
    url: '/resource/queue/list',
    method: 'get',
    params: query
  })
}

// 查询检查队列详细
export function getQueue(id) {
  return request({
    url: '/resource/queue/' + id,
    method: 'get'
  })
}

// 新增检查队列
export function addQueue(data) {
  return request({
    url: '/resource/queue',
    method: 'post',
    data: data
  })
}

// 修改检查队列
export function updateQueue(data) {
  return request({
    url: '/resource/queue',
    method: 'put',
    data: data
  })
}

// 删除检查队列
export function delQueue(id) {
  return request({
    url: '/resource/queue/' + id,
    method: 'delete'
  })
}

// 导出检查队列
export function exportQueue(query) {
  return request({
    url: '/resource/queue/export',
    method: 'get',
    params: query
  })
}

// 查询
export function queryQueueItems(query) {
  return request({
    url: '/resource/queue/queueItemList',
    method: 'get',
    params: query
  })
}

// 添加
export function addQueueItem(query) {
  return request({
    url: '/resource/queue/queueItem',
    method: 'post',
    params: query
  })
}

// 添加
export function addApplyDept(data) {
  return request({
    url: '/resource/queue/apply/set',
    method: 'post',
    data
  })
}

// 添加
export function queryApplyDept(id) {
  return request({
    url: '/resource/queue/apply/' + id,
    method: 'get'
  })
}
