import request from '@/utils/request'

const prefix = '/dataImport'

/**
 * 模板查询
 * @param params
 * @returns {*}
 */
export function queryTemplate(params) {
    return request({
        url: `${prefix}/template`,
        method: 'get',
        params
    })
}

/**
 * 新增模板
 * @param data
 * @returns {*}
 */
export function addTemplate(data) {
    return request({
        url: `${prefix}/template`,
        method: 'post',
        data
    })
}

/**
 * 修改模板
 * @param data
 * @returns {*}
 */
export function updateTemplate(data) {
    return request({
        url: `${prefix}/template`,
        method: 'put',
        data
    })
}

/**
 * 删除模板
 * @param templateId
 * @returns {*}
 */
export function deleteTemplate(templateId) {
    return request({
        url: `${prefix}/template`,
        method: 'delete',
        params:{templateId}
    })
}


/**
 * 字典查询
 * @param type
 * @returns {*}
 */
export function queryDict(type) {
    return request({
        url: `${prefix}/dict`,
        method: 'get',
        params:{type}
    })
}

/**
 * 新增字典
 * @param data
 * @returns {*}
 */
export function addDict(data) {
    return request({
        url: `${prefix}/dict`,
        method: 'post',
        data
    })
}

/**
 * 修改字典
 * @param data
 * @returns {*}
 */
export function updateDict(data) {
    return request({
        url: `${prefix}/dict`,
        method: 'put',
        data
    })
}

/**
 * 删除字典
 * @param dictId
 * @returns {*}
 */
export function deleteDict(dictId) {
    return request({
        url: `${prefix}/dict`,
        method: 'delete',
        params:{dictId}
    })
}
