import request from '@/utils/request'

/**
 * 预约接口
 */

/**
 * 获取申请单列表信息
 * @param applyNum
 * @returns {*}
 */
export function getApplyList(applyNum) {
  return request({
    url: '/reservation/apply',
    method: 'get',
    params: { applyNum }
  })
}

/**
 * 获取病区列表
 * @returns {*}
 */
export function getWardList() {
  return request({
    url: '/reservation/wardList',
    method: 'get'
  })
}

/**
 * 查询是否有号源
 * @param data
 * @returns {*}
 */
export function hasSource(data) {
  return request({
    url: '/reservation/hasSource',
    method: 'post',
    data
  })
}

/**
 * 获取号源列表
 * @param data
 * @returns {*}
 */
export function getSourceList(data) {
  return request({
    url: '/reservation/sourceList',
    method: 'post',
    data
  })
}

/**
 * 预约与改约
 * @param data
 * @returns {*}
 */
export function reservation(data) {
  return request({
    url: '/reservation/reservation',
    method: 'post',
    data
  })
}

/**
 * 取消预约
 * @param data
 * @returns {*}
 */
export function cancelReservation(data) {
  return request({
    url: '/reservation/cancelReservation',
    method: 'post',
    data
  })
}

/**
 * 单个申请单自动预约
 * @param data
 * @returns {*}
 */
export function autoReservation(data) {
  return request({
    url: '/reservation/autoReservation',
    method: 'post',
    data
  })
}
