import request from '@/utils/request'

export const prefix = '/system/dept'

// 获取医院机构list
export function getHspOption() {
    return request({
      url: prefix + '/getHspOption',
      method: 'get'
    })
}

// 查询机构列表
export function listDept(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询机构详细
export function getDept(deptId) {
  return request({
    url: prefix + '/' + deptId,
    method: 'get'
  })
}

// 查询机构下拉树结构
export function treeselect() {
  return request({
    url: prefix + '/treeselect',
    method: 'get'
  })
}

// 根据角色ID查询机构树结构
export function roleDeptTreeselect(roleId) {
  return request({
    url: prefix + '/roleDeptTreeselect/' + roleId,
    method: 'get'
  })
}

// 新增机构
export function addDept(data) {
  return request({
    url: prefix + '',
    method: 'post',
    data: data
  })
}

// 修改机构
export function updateDept(data) {
  return request({
    url: prefix + '',
    method: 'put',
    data: data
  })
}

// 删除机构
export function delDept(deptId) {
  return request({
    url: prefix + '/' + deptId,
    method: 'delete'
  })
}

export function deptChannelTreeselect(deptId) {
  return request({
    url: prefix + '/deptChannelTreeselect/' + deptId,
    method: 'get'
  })
}