import request from '@/utils/request'

// 查询外部检查项目列表
export function listOutexamitem(data) {
  return request({
    url: '/basis/outexamitem/list',
    method: 'get',
    params: data
  })
}

// 查询外部检查项目详细
export function getOutexamitem(id) {
  return request({
    url: '/basis/outexamitem/' + id,
    method: 'get'
  })
}

// 新增外部检查项目
export function addOutexamitem(data) {
  return request({
    url: '/basis/outexamitem',
    method: 'post',
    data: data
  })
}

// 修改外部检查项目
export function updateOutexamitem(data) {
  return request({
    url: '/basis/outexamitem',
    method: 'put',
    data: data
  })
}

// 删除外部检查项目
export function delOutexamitem(id) {
  return request({
    url: '/basis/outexamitem/' + id,
    method: 'delete'
  })
}

// 导出外部检查项目
export function exportOutexamitem(query) {
  return request({
    url: '/basis/outexamitem/export',
    method: 'get',
    params: query
  })
}


// 同步外部检查项目
export function syncOutexamitem(query) {
  return request({
    url: '/basis/outexamitem/sync',
    method: 'get',
    params: query
  })
}
