import request from '@/utils/request'

// 查询基础信息设置列表
export function listBasicInfosetting(query) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting/list',
    method: 'get',
    params: query
  })
}

// 查询基础信息设置详细
export function getBasicInfosetting(id) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting/' + id,
    method: 'get'
  })
}

// 新增基础信息设置
export function addBasicInfosetting(data) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting',
    method: 'post',
    data: data
  })
}

// 修改基础信息设置
export function updateBasicInfosetting(data) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting',
    method: 'put',
    data: data
  })
}

// 删除基础信息设置
export function delBasicInfosetting(id) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting/' + id,
    method: 'delete'
  })
}

// 导出基础信息设置
export function exportBasicInfosetting(query) {
  return request({
    url: '/BasicInfoSetting/basicInfosetting/export',
    method: 'get',
    params: query
  })
}