import request from '@/utils/request'

// 查询部门信息列表
export function listDept(query) {
  return request({
    url: '/basis/dept/list',
    method: 'get',
    params: query
  })
}

// 查询部门信息字典
export function getDeptDict() {
  return request({
    url: '/basis/dept/dict',
    method: 'get'
  })
}

// 查询部门信息详细
export function getDept(id) {
  return request({
    url: '/basis/dept/' + id,
    method: 'get'
  })
}

// 新增部门信息
export function addDept(data) {
  return request({
    url: '/basis/dept',
    method: 'post',
    data: data
  })
}

// 修改部门信息
export function updateDept(data) {
  return request({
    url: '/basis/dept',
    method: 'put',
    data: data
  })
}

// 删除部门信息
export function delDept(id) {
  return request({
    url: '/basis/dept/' + id,
    method: 'delete'
  })
}

// 导出部门信息
export function exportDept(query) {
  return request({
    url: '/basis/dept/export',
    method: 'get',
    params: query
  })
}

// 同步部门信息
export function syncDept(query) {
  return request({
    url: '/basis/dept/sync',
    method: 'get',
    params: query
  })
}


//查询检查类型
export function getExamDept(id) {
  return request({
    url: '/basis/dept/exmadept?deptId=' + id,
    method: 'get'
  })
}

//检查类型关联信息操作
export function addExamDept(data) {
  return request({
    url: '/basis/dept/examdept/operation',
    method: 'post',
    params: data
  })
}
