import request from '@/utils/request'

// 查询检查类型列表
export function listExamtype(query) {
  return request({
    url: '/basis/examtype/list',
    method: 'get',
    params: query
  })
}

// 查询检查类型详细
export function getExamtype(id) {
  return request({
    url: '/basis/examtype/' + id,
    method: 'get'
  })
}

// 新增检查类型
export function addExamtype(data) {
  return request({
    url: '/basis/examtype',
    method: 'post',
    data: data
  })
}

// 修改检查类型
export function updateExamtype(data) {
  return request({
    url: '/basis/examtype',
    method: 'put',
    data: data
  })
}

// 删除检查类型
export function delExamtype(id) {
  return request({
    url: '/basis/examtype/' + id,
    method: 'delete'
  })
}

// 导出检查类型
export function exportExamtype(query) {
  return request({
    url: '/basis/examtype/export',
    method: 'get',
    params: query
  })
}