import HttpUtil from "@/utils/document/HttpUtil.js";


/**
 * 获取资源目录列表
 * @returns {Promise<*>}
 */
export function getCatalogList() {
    return HttpUtil.getForJson("/resource/list")
}

/**
 * 查询资源
 * @param params
 * @returns {Promise<*>}
 */
export function getResourceList(params) {
    return HttpUtil.getForJson("/resource/query", {params})
}

/**
 * 上传资源
 * @param file
 * @param data
 * @returns {Promise<*>}
 */
export function uploadResource(file, data) {
    return HttpUtil.upload("/resource/upload", file, data)
}

/**
 * 文档重试上传
 * @param file
 * @param data
 * @returns {Promise<*>}
 */
export function retryUploadResource(file, data) {
    return HttpUtil.upload("/resource/retry", file, data)
}

/**
 * 统计数据集数量
 * @returns {Promise<*>}
 */
export function statisticsDatasetCount() {
  return HttpUtil.getForJson("/resource/statistics/dataset")
}
