import request from "@/utils/request";

const prefix = '/data/field'

/**
 * 字段查询
 * @param params
 * @returns {*}
 */
export function queryField(params) {
    return request({
        url: `${prefix}`,
        method: 'get',
        params
    })
}

/**
 * 新增字段
 * @param data
 * @returns {*}
 */
export function addField(data) {
    return request({
        url: `${prefix}`,
        method: 'post',
        data
    })
}

/**
 * 修改字段
 * @param data
 * @returns {*}
 */
export function updateField(data) {
    return request({
        url: `${prefix}/update`,
        method: 'post',
        data
    })
}


/**
 * 删除字段
 * @param fieldId
 * @returns {*}
 */
export function deleteField(fieldId) {
    return request({
        url: `${prefix}/delete`,
        method: 'get',
        params:{fieldId}
    })
}

/**
 * 根据基础模板重置字段
 * @param excelId
 * @returns {*}
 */
export function resetField(excelId){
    return request({
        url: `${prefix}/reset`,
        method: 'get',
        params:{excelId}
    })
}
