import request from "@/utils/request";

const prefix = '/data/rule'

/**
 * 规则查询
 * @param params
 * @returns {*}
 */
export function queryRule(params) {
    return request({
        url: `${prefix}`,
        method: 'get',
        params
    })
}

/**
 * 规则字典
 * @returns {*}
 */
export function queryRuleDict() {
    return request({
        url: `${prefix}/dict`,
        method: 'get'
    })
}

/**
 * 新增规则
 * @param data
 * @returns {*}
 */
export function addRule(data) {
    return request({
        url: `${prefix}`,
        method: 'post',
        data
    })
}

/**
 * 修改规则
 * @param data
 * @returns {*}
 */
export function updateRule(data) {
    return request({
        url: `${prefix}/update`,
        method: 'post',
        data
    })
}

/**
 * 删除规则
 * @param ruleId
 * @returns {*}
 */
export function deleteRule(ruleId) {
    return request({
        url: `${prefix}/delete`,
        method: 'get',
        params:{ruleId}
    })
}

/**
 * 规则测试
 * @param data
 * @returns {*}
 */
export function ruleTest(data) {
    return request({
        url: `${prefix}/test`,
        method: 'post',
        data
    })
}


/**
 * 快速绑定
 * @param templateId
 * @param ruleId
 * @returns {AxiosPromise}
 */
export function quickBind(templateId,ruleId) {
    return request({
        url: `${prefix}/bind/quick`,
        method: 'get',
        params:{templateId,ruleId}
    })
}

/**
 * 查询绑定的规则
 * @param fieldId
 * @returns {AxiosPromise}
 */
export function queryBindRule(fieldId) {
    return request({
        url: `${prefix}/bind`,
        method: 'get',
        params:{fieldId}
    })
}

/**
 * 配置字段规则绑定
 * @param data
 * @returns {AxiosPromise}
 */
export function bindRule(data) {
    return request({
        url: `${prefix}/bind`,
        method: 'post',
        data
    })
}
