import request from "@/utils/request";

const prefix = '/data/dict'

/**
 * 字典查询
 * @param type
 * @returns {*}
 */
export function queryDict(type) {
    return request({
        url: `${prefix}`,
        method: 'get',
        params:{type}
    })
}

/**
 * 新增字典
 * @param data
 * @returns {*}
 */
export function addDict(data) {
    return request({
        url: `${prefix}`,
        method: 'post',
        data
    })
}

/**
 * 修改字典
 * @param data
 * @returns {*}
 */
export function updateDict(data) {
    return request({
        url: `${prefix}/update`,
        method: 'post',
        data
    })
}

/**
 * 删除字典
 * @param dictId
 * @returns {*}
 */
export function deleteDict(dictId) {
    return request({
        url: `${prefix}/delete`,
        method: 'get',
        params:{dictId}
    })
}
