import request from '@/utils/request'

export const prefix = '/mapi/menu'

// 查询详情
export function listMenu(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询视图
export function listView(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询视图
export function getView(id) {
  return request({
    url: prefix + '/' + id,
    method: 'get'
  })
}

// 新增视图
export function addView(data) {
  return request({
    url: prefix,
    method: 'post',
    data: data
  })
}

// 修改视图
export function updateView(data) {
  return request({
    url: prefix,
    method: 'put',
    data: data
  })
}

// 删除视图
export function delView(id) {
    return request({
      url: prefix + '/' + id,
      method: 'delete'
    })
  }

//导出视图
export function exportView(query) {
  return request({
    url: prefix + '/export',
    method: 'get',
    params: query
  })
}