import request from "@/utils/request";

// 登录方法
export function login(username, password, code, uuid) {
  const data = {
    username,
    password,
    code,
    uuid
  };
  return request({
    url: '/login',
    method: 'post',
    params: data
  })
}

// 开放登录
export function loginOpen(userName) {
  return request({
    url: '/resource/open/login',
    method: 'get',
    params: {
      userName
    }
  })
}

// 获取用户详细信息
export function getInfo() {
  return request({
    url: '/getInfo',
    method: 'get'
  })
}

// 退出方法
export function logout() {
  return request({
    url: "/logout",
    method: "post"
  });
}

// 获取验证码
export function getCodeImg(token) {
  return request({
    url: "/captchaImage",
    method: "get",
    params:{
      "token": token
    }
  });
}

// 获取手机短信验证码
export function getPhoneCode() {
  return request({
    url: "/getPhoneCode",
    method: "get"
  });
}

//获取单点登录信息
export function getSSOResult(token) {
  return request({
    url: '/getSSOResult',
    method: 'get',
    params:{
      "token": token
    }
  })
}
