import request from '@/utils/request'

// 查询预约报表列表
export function listApplyReport(query) {
  return request({
    url: '/monitor/ApplyReport/list',
    method: 'get',
    params: query
  })
}

// 查询预约报表详细
export function getApplyReport(id) {
  return request({
    url: '/monitor/ApplyReport/' + id,
    method: 'get'
  })
}

// 新增预约报表
export function addApplyReport(data) {
  return request({
    url: '/monitor/ApplyReport',
    method: 'post',
    data: data
  })
}

// 修改预约报表
export function updateApplyReport(data) {
  return request({
    url: '/monitor/ApplyReport',
    method: 'put',
    data: data
  })
}

// 删除预约报表
export function delApplyReport(id) {
  return request({
    url: '/monitor/ApplyReport/' + id,
    method: 'delete'
  })
}

// 导出预约报表
export function exportApplyReport(query) {
  return request({
    url: '/monitor/ApplyReport/export',
    method: 'get',
    params: query
  })
}