import request from '@/utils/request'

// 查询检查申请单列表
export function listApply(query) {
  return request({
    url: '/resource/apply/list',
    method: 'get',
    params: query
  })
}

// 手动预约查询检查申请单列表
export function listByManual(data) {
  return request({
    url: '/resource/apply/listByManual',
    method: 'post',
    data
  })
}
export function applyDetailInfoList(query) {
  return request({
    url: '/resource/apply/applyDetailInfoList',
    method: 'get',
    params: query
  })
}

// 查询检查申请单详细
export function getApply(id) {
  return request({
    url: '/resource/apply/' + id,
    method: 'get'
  })
}

// 新增检查申请单
export function addApply(data) {
  return request({
    url: '/resource/apply',
    method: 'post',
    data: data
  })
}

// 预约检查申请单
export function updateApply(data) {
  return request({
    url: '/resource/apply',
    method: 'put',
    data: data
  })
}

// 修改检查申请单
export function changeApply(data) {
  return request({
    url: '/resource/apply/change',
    method: 'put',
    data: data
  })
}

// 删除检查申请单
export function delApply(id) {
  return request({
    url: '/resource/apply/' + id,
    method: 'delete'
  })
}

// 导出检查申请单
export function exportApply(query) {
  return request({
    url: '/resource/apply/export',
    method: 'get',
    params: query
  })
}

// 取消预约
export function cancelApply(query) {
  return request({
    url: '/resource/apply/cancelApply',
    method: 'put',
    data: query
  })
}

// 停诊并且取消预约
export function stopReservation(ids) {
  return request({
    url: '/resource/apply/stopReservation',
    method: 'get',
    params: {ids}
  })
}
export function selectApplysByStop(ids) {
  return request({
    url: '/resource/apply/selectApplysByStop',
    method: 'post',
    params: {ids}
  })
}
export function exportApplyByStop(ids) {
  return request({
    url: '/resource/apply/exportApplyByStop',
    method: 'post',
    params: {ids}
  })
}
// 打印次数
export function printApply(id) {
  return request({
    url: '/resource/apply/printCount',
    method: 'put',
    params: id
  })
}


//
export function deptType() {
  return request({
    url: '/mapi/public/deptType',
    method: 'get'
  })
}

/**
 * 预约统计查询
 * @param data
 */
export function getAppointmentStatistics(data) {
  return request({
    url: '/resource/apply/statistics',
    method: 'post',
    data: data
  })
}


/**
 * 预约统计查询
 * @param data
 */
export function queryByQueue(query) {
  return request({
    url: '/resource/apply/queryByQueue',
    method: 'get',
    params: query
  })
}
