import request from '@/utils/request'

// 查询预约操作记录列表
export function listApplyAction(query) {
  return request({
    url: '/resource/applyAction/list',
    method: 'get',
    params: query
  })
}

// 查询预约操作记录详细
export function getApplyAction(id) {
  return request({
    url: '/resource/applyAction/' + id,
    method: 'get'
  })
}

// 新增预约操作记录
export function addApplyAction(data) {
  return request({
    url: '/resource/applyAction',
    method: 'post',
    data: data
  })
}

// 修改预约操作记录
export function updateApplyAction(data) {
  return request({
    url: '/resource/applyAction',
    method: 'put',
    data: data
  })
}

// 删除预约操作记录
export function delApplyAction(id) {
  return request({
    url: '/resource/applyAction/' + id,
    method: 'delete'
  })
}

// 导出预约操作记录
export function exportApplyAction(query) {
  return request({
    url: '/resource/applyAction/export',
    method: 'get',
    params: query
  })
}