import request from '@/utils/request'

/**
 * 查询患者列表
 * @param query
 * @returns {*}
 */
export function patientList(query) {
  return request({
    url: '/resource/hospitalizationSubscribe/patientList',
    method: 'get',
    params: query
  })
}

/**
 * 主要根据多个患者查询申请单信息
 * @param data
 * @returns {*}
 */
export function getApplyListByPatient(data) {
  return request({
    url: '/resource/hospitalizationSubscribe/getApplyListByPatient',
    method: 'get',
    params: data
  })
}

// 查询病区列表
export function xtbmList(query) {
  return request({
    url: '/resource/hospitalizationSubscribe/getXtbmList',
    method: 'get',
    params: query
  })
}

// 查询检查项目列表
export function examItemList(data) {
  return request({
    url: '/resource/hospitalizationSubscribe/examItemList',
    method: 'post',
    data
  })
}

// 一键预约
export function reservation(data) {
  return request({
    url: '/resource/hospitalizationSubscribe/reservation',
    method: 'post',
    data: data
  })
}

// 打印项目
export function exportExam(data) {
  return request({
    url: '/resource/hospitalizationSubscribe/export',
    method: 'post',
    data: data
  })
}

// 修改申请单推床状态与加急状态
export function updateApply(data) {
  return request({
    url: '/resource/hospitalizationSubscribe/update',
    method: 'post',
    data: data
  })
}
