import request from '@/utils/request'

/**
 * 查询互斥组关联信息
 * @param query
 * @returns {*}
 */
export function getItemGroupRelation(query) {
  return request({
    url: '/resource/item-group/list/relation',
    method: 'get',
    params: query
  })
}

/**
 * 保存项目组关联信息
 * @param data
 * @returns {*}
 */
export function saveItemGroupRelation(data) {
  return request({
    url: '/resource/item-group/relation/save',
    method: 'post',
    data
  })
}

/**
 * 查询项目组列表
 * @param query
 * @returns {*}
 */
export function getItemGroupList(query) {
  return request({
    url: '/resource/item-group/list',
    method: 'get',
    params: query
  })
}

/**
 * 修改或保存项目组基本信息
 * @param data
 * @returns {*}
 */
export function saveOrUpdateGroup(data) {
  return request({
    url: '/resource/item-group/saveOrUpdate',
    method: 'post',
    data
  })
}

/**
 * 删除项目组
 * @param query
 * @returns {*}
 */
export function deleteGroup(query) {
  return request({
    url: '/resource/item-group/delete',
    method: 'get',
    params: query
  })
}


/**
 * 获取组组规则列表
 * @param query
 * @returns {*}
 */
export function getRuleList(query) {
  return request({
    url: '/resource/item-group/rule/list',
    method: 'get',
    params: query
  })
}

/**
 * 保存或修改组组规则配置
 * @param data
 * @returns {*}
 */
export function saveOrUpdateRule(data) {
  return request({
    url: '/resource/item-group/rule/saveOrUpdate',
    method: 'post',
    data
  })
}

/**
 * 删除组间规则列表
 * @param query
 * @returns {*}
 */
export function deleteGroupRule(query) {
  return request({
    url: '/resource/item-group/rule/delete',
    method: 'get',
    params: query
  })
}
