import request from '@/utils/request'

// 查询队列基础号列表
export function listQueueBasicNum(query) {
  return request({
    url: '/resource/queueBasicNum/list',
    method: 'get',
    params: query
  })
}

// 根据设置ID查询全部队列基础号列表
export function listAllQueueBasicNum(queueSetId) {
  return request({
    url: `/resource/queueBasicNum/listAll/${queueSetId}`,
    method: 'get'
  })
}

// 查询队列基础号详细
export function getQueueBasicNum(id) {
  return request({
    url: '/resource/queueBasicNum/' + id,
    method: 'get'
  })
}

// 新增队列基础号
export function addQueueBasicNum(data) {
  return request({
    url: '/resource/queueBasicNum',
    method: 'post',
    data: data
  })
}

// 重置队列基础号
export function resetQueueBasicNum(data) {
  return request({
    url: '/resource/queueBasicNum/reset',
    method: 'post',
    data: data
  })
}

// 修改队列基础号
export function updateQueueBasicNum(data) {
  return request({
    url: '/resource/queueBasicNum',
    method: 'put',
    data: data
  })
}

// 删除队列基础号
export function delQueueBasicNum(id) {
  return request({
    url: '/resource/queueBasicNum/' + id,
    method: 'delete'
  })
}

// 导出队列基础号
export function exportQueueBasicNum(query) {
  return request({
    url: '/resource/queueBasicNum/export',
    method: 'get',
    params: query
  })
}

// 新增队列基础号
export function addBasicNum(data) {
  return request({
    url: '/resource/queueBasicNum/add',
    method: 'post',
    data: data
  })
}

// 修改队列基础号
export function updateBasicNum(data) {
  return request({
    url: '/resource/queueBasicNum/update',
    method: 'post',
    data: data
  })
}
