import request from '@/utils/request'

// 查询号源池列表
export function listSourcePool(query) {
  return request({
    url: '/resource/sourcePool/list',
    method: 'get',
    params: query
  })
}

export function listSourcePools(query) {
  return request({
    url: '/resource/sourcePool/listData',
    method: 'get',
    params: query
  })
}

export function listSourcePoolToManage(query) {
  return request({
    url: '/resource/sourcePool/listDateToManage',
    method: 'get',
    params: query
  })
}

/**
 * 手动预约号源列表查询
 */
export function sourceListByExamType(query) {
  return request({
    url: '/resource/sourcePool/sourceListByExamType',
    method: 'get',
    params: query
  })
}

// 查询号源池详细
export function getSourcePool(id) {
  return request({
    url: '/resource/sourcePool/' + id,
    method: 'get'
  })
}

// 新增号源池
export function addSourceNum(ids) {
  return request({
    url: '/resource/sourcePool/addSourceNum/'+ ids,
    method: 'post',
  })
}

// 减少号源池
export function lessSourceNum(ids) {
  return request({
    url: '/resource/sourcePool/lessSourceNum/'+ ids,
    method: 'delete',
  })
}

// 删除号源池
export function delSourcePool(id) {
  return request({
    url: '/resource/sourcePool/' + id,
    method: 'delete'
  })
}

// 导出号源池
export function exportSourcePool(query) {
  return request({
    url: '/resource/sourcePool/export',
    method: 'get',
    params: query
  })
}

// 修改号源池
export function updateSourcePool(data) {
  return request({
    url: '/resource/sourcePool',
    method: 'put',
    data: data
  })
}

// 加减号源
export function editSourcePool(data) {
  return request({
    url: '/resource/sourcePool/edit',
    method: 'put',
    data: data
  })
}
