import request from "@/utils/request";

export const prefix = "/demo/lkTrade";

// 查询商品交易订单
export function listLkTrade(query) {
  return request({
    url: prefix + "/list",
    method: "get",
    params: query
  });
}

// 查询商品交易订单
export function getLkTrade(id) {
  return request({
    url: prefix + "/" + id,
    method: "get"
  });
}

// 新增商品交易订单
export function addLkTrade(data) {
  return request({
    url: prefix,
    method: "post",
    data: data
  });
}

// 修改商品交易订单
export function updateLkTrade(data) {
  return request({
    url: prefix,
    method: "put",
    data: data
  });
}

// 删除商品交易订单
export function delLkTrade(id) {
  return request({
    url: prefix + "/" + id,
    method: "delete"
  });
}

// 清空表
export function clearTable() {
  return request({
    url: prefix + "/clear",
    method: "delete"
  });
}

//导出商品交易订单
export function exportLkTrade(query) {
  return request({
    url: prefix + "/export",
    method: "get",
    params: query
  });
}
// 退款
export function fundLkTrade(id) {
  return request({
    url: prefix + "/fundLkTrade/?id=" + id,
    method: "get"
  });
}
