import request from '@/utils/request'

export const prefix = '/system/userWechat'

// 查询微信用户
export function listUserWechat(query) {
  return request({
    url: prefix + '/list',
    method: 'get',
    params: query
  })
}

// 查询微信用户
export function getUserWechat(id) {
  return request({
    url: prefix + '/' + id,
    method: 'get'
  })
}

// 新增微信用户
export function addUserWechat(data) {
  return request({
    url: prefix,
    method: 'post',
    data: data
  })
}

// 修改微信用户
export function updateUserWechat(data) {
  return request({
    url: prefix,
    method: 'put',
    data: data
  })
}

// 删除微信用户
export function delUserWechat(id) {
    return request({
      url: prefix + '/' + id,
      method: 'delete'
    })
  }

//导出微信用户
export function exportUserWechat(query) {
  return request({
    url: prefix + '/export',
    method: 'get',
    params: query
  })
}