const state = {
    fromRouter: null, // 路由来自菜单（1:预约管理，2：住院批量预约）
    patientInfo: null, // 患者信息
    applyInfo: null, // 申请单信息
};

const mutations = {
    SET_APPLYINFO: (state, data) => {
        state.applyInfo = data;
    },
    SET_PATIENTINFO: (state, data) => {
        state.patientInfo = data;
    },
    SET_FROMROUTER: (state, data) => {
        state.fromRouter = data;
    }
}

const actions = {
    setApplyInfo({ commit }, data) {
        commit('SET_APPLYINFO', data)
    },
    setPatientInfo({ commit }, data) {
        commit('SET_PATIENTINFO', data)
    },
    setFromRouter({ commit }, data) {
        commit('SET_FROMROUTER', data)
    },
}

export default {
    namespaced: true,
    state,
    mutations,
    actions
}