import {login, logout, getInfo} from '@/api/login'
import {getToken, setToken, removeToken} from '@/utils/auth'
import Cookies from "js-cookie";

const defaultSettings = require('@/settings')

const getLoginUser = () => {
  if (window.localStorage.hasOwnProperty('loginUser')) {
    console.log(JSON.parse(window.localStorage.getItem('loginUser')))
    return JSON.parse(window.localStorage.getItem('loginUser'))
  }
  return null
}

const user = {
  state: {
    token: getToken(),
    name: '',
    avatar: '',
    roles: [],
    permissions: [],
    hospital: '',
    dept: '',
    deptCode: undefined,
    deptName: undefined,
    orgCode: '',
    loginCode: '',
    loginUser: getLoginUser() || {}
  },

  mutations: {
    SET_TOKEN: (state, token) => {
      state.token = token
    },
    SET_NAME: (state, name) => {
      state.name = name
    },
    SET_AVATAR: (state, avatar) => {
      state.avatar = avatar
    },
    SET_ROLES: (state, roles) => {
      state.roles = roles
    },
    SET_LOGIN_USER: (state, loginUser) => {
      state.loginUser = loginUser
      window.localStorage.setItem('loginUser', JSON.stringify(loginUser))
    },
    SET_PERMISSIONS: (state, permissions) => {
      state.permissions = permissions
    } //缓存机构10、院区
  },

  actions: {
    // 登录
    Login({commit}, userInfo) {
      const username = userInfo.username.trim()
      const password = userInfo.password
      const code = userInfo.code
      const uuid = userInfo.uuid
      const hospital = userInfo.hospital
      const dept = userInfo.dept
      return new Promise((resolve, reject) => {
        login(username, password, code, uuid, hospital, dept)
          .then((res) => {
            setToken(res.token)
            commit('SET_TOKEN', res.token)
            // commit("SET_HOSPITAL", hospital);
            // commit("SET_DEPT", dept);
            resolve()
          })
          .catch((error) => {
            reject(error)
          })
      })
    },

    autoLogin({commit}, {token, username}) {
      return new Promise((resolve, reject) => {
        setToken(token)
        window.localStorage.removeItem("loginUser")
        Cookies.set("username", username)
        commit('SET_TOKEN', token)
        resolve()
      })
    },

    // 获取用户信息
    GetInfo({commit, state}) {
      return new Promise((resolve, reject) => {
        getInfo()
          .then((res) => {
            commit('SET_LOGIN_USER', res.loginUser)
            const user = res.user
            const avatar =
              user.avatar == ''
                ? require('@/assets/images/profile.jpg')
                : process.env.VUE_APP_BASE_API + user.avatar
            if (res.roles && res.roles.length > 0) {
              // 验证返回的roles是否是一个非空数组
              commit('SET_ROLES', res.roles)
              commit('SET_PERMISSIONS', res.permissions)
            } else {
              commit('SET_ROLES', ['ROLE_DEFAULT'])
            }
            commit('SET_NAME', user.userName)
            commit('SET_AVATAR', avatar)
            resolve(res)
          })
          .catch((error) => {
            reject(error)
          })
      })
    },

    // 退出系统
    LogOut({commit, state}) {
      return new Promise((resolve, reject) => {
        logout(state.token)
          .then(() => {
            commit('SET_TOKEN', '')
            commit('SET_ROLES', [])
            commit('SET_PERMISSIONS', [])
            removeToken()
            resolve()
            window.location.href = defaultSettings.caslogoutUrl
          })
          .catch((error) => {
            reject(error)
          })
      })
    },

    // 前端 登出
    FedLogOut({commit}) {
      return new Promise((resolve) => {
        commit('SET_TOKEN', '')
        removeToken()
        resolve()
      })
    }
  }
}

export default user
