export default class ArrayUtil {

    /**
     * 判断数组是否为空,如果是别的类型也返回true
     * @param arr
     * @returns {boolean}
     */
    static isEmpty(arr) {
        try {
            if (arr === '' || arr === null || arr === undefined) {
                return true;
            }
            return arr.length <= 0;
        } catch (e) {
            console.log('判断数据为空时出现异常', e, arr);
            return true;
        }
    }

    /**
     * 数组去重
     * @param arr
     * @returns {unknown[]|*[]}
     */
    static unique(arr) {
        if (this.isEmpty(arr)) {
            return [];
        }
        return Array.from(new Set(arr));
    }

    /**
     * 数组去重
     * @param arr       源数组
     * @param predicate {function(source,target)} 定义对象比较规则
     * @returns {*[]}
     */
    static uniqueArr(arr = [], predicate) {
        for (let i = 0; i < arr.length; i++) {
            for (let j = i + 1; j < arr.length; j++) {
                if (predicate(arr[j], arr[i])) {
                    arr.splice(j, 1);
                    j -= 1;
                }
            }
        }
        return arr;
    }

    /**
     * 查询数组中最后一次出现的元素
     * @param arr
     * @param predicate {function(object)}
     */
    static findLast(arr = [], predicate) {
        for (let i = arr.length - 1; i >= 0; i--) {
            if (predicate(arr[i])) {
                return arr[i];
            }
        }
        return undefined;
    }

    /**
     * 移除数组中某个对应的元素
     * @param arr   数组
     * @param predicate   function(item)  item为数组中的每一项
     */
    static remove(arr = [], predicate) {
        let index = arr.findIndex((item) => predicate(item));
        if (index !== -1) {
            arr.splice(index, 1);
        }
    }

    /**
     * 对象转换为 key,value 形式的数组
     * @param obj
     * @returns {*[]}
     */
    static objectToList(obj) {
        let list = [];
        if (obj === null || obj === undefined) {
            return list;
        }
        Object.keys(obj).forEach((key) => {
            list.push({key, value: obj[key]});
        });
        return list;
    }
}
