export default class WindowUtil {

    /**
     * 获取全局loadingBBar
     * @returns {*}
     */
    static loadingBar() {
        return window.loadingBar
    }

    /**
     * 打开新页面地址
     * @param url
     * @param target
     */
    static open(url, target = '_blank') {
        window.open(url, target)
    }

    /**
     * 开启窗口
     * window.screen.height获得屏幕的高，window.screen.width获得屏幕的宽
     * @param width  838
     * @param height window.screen.height-150
     * @param name  文档预览
     * @param url   http://localhost:8080/view/export?documentCode=6984693fc7f24d96934cf9d21b12b83d
     */
    static openWindow(width, height, url, name) {
        let iTop = (window.screen.height - 30 - height) / 2;       //获得窗口的垂直位置;
        let iLeft = (window.screen.width - 10 - width) / 2;        //获得窗口的水平位置;
        window.open(url, name,
            'height=' + height + ',innerHeight=' + height + ',width=' + width + ',innerWidth=' + width + ',top=' + iTop + ',left=' + iLeft + ',toolbar=no,menubar=no,scrollbars=auto,resizable=no,location=no,status=no')
    }

    /**
     * 生成uuid
     * @param format     格式化去掉中间的-
     * @returns {string}
     */
    static uuid(format = false) {
        const s = [];
        const hexDigits = "0123456789abcdef";
        for (let i = 0; i < 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[14] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        s[8] = s[13] = s[18] = s[23] = "-";
        const uuid = s.join("");
        return format ? uuid.replaceAll("-", "") : uuid;
    }

}
