import { getToken } from '@/utils/auth'
import axios from "axios";

axios.defaults.headers["Content-Type"] = "application/json;charset=utf-8";

const service = axios.create({
  baseURL: process.env.VUE_APP_BASE_API, // api base_url
  timeout: 6000 // 请求超时时间
});

service.interceptors.request.use(
    config => {
      if (getToken()) {
        config.headers['Authorization'] = 'Bearer ' + getToken() // 让每个请求携带自定义token 请根据实际情况自行修改
      }
      return config
    },
    error => {
      console.log(error)
      Promise.reject(error)
    }
  )

export default service